/*
 * Decompiled with CFR 0.152.
 */
package dev.ArkNLA.GridMap;

import dev.ArkNLA.GridMap.EntityObject;
import dev.ArkNLA.GridMap.GridMapMain;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PaneEntity
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    ArrayList<EntityObject> arrayEntities = new ArrayList();
    ArrayList<JButton> butGoto = new ArrayList();
    ArrayList<JButton> butDelete = new ArrayList();
    JLabel statusMsg = new JLabel("");
    JPanel paneGoto = new JPanel();

    PaneEntity() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.statusMsg);
        this.loadEntitiesFromFile();
        this.populateEntities();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int i = 0;
        while (i < this.butGoto.size()) {
            if (source == this.butGoto.get(i)) {
                GridMapMain.centerViewportCoordX = this.arrayEntities.get(i).getCoordX();
                GridMapMain.centerViewportCoordY = this.arrayEntities.get(i).getCoordY();
                GridMapMain.paneMap.gotoCoord();
            }
            ++i;
        }
        i = 0;
        while (i < this.butDelete.size()) {
            if (source == this.butDelete.get(i)) {
                this.arrayEntities.remove(i);
                this.butGoto.remove(i);
                this.butDelete.remove(i);
                this.saveEntitiesToFile();
                this.populateEntities();
                this.revalidate();
            }
            ++i;
        }
    }

    public void addEntity(EntityObject ent) {
        this.arrayEntities.add(ent);
        this.saveEntitiesToFile();
        this.populateEntities();
        this.revalidate();
    }

    private void populateEntities() {
        this.removeAll();
        this.statusMsg.setText("Entities List");
        this.add(this.statusMsg);
        int i = 0;
        while (i < this.arrayEntities.size()) {
            JPanel box = new JPanel();
            JLabel jlName = new JLabel(this.arrayEntities.get(i).getName());
            JLabel jlGroup = new JLabel(this.arrayEntities.get(i).getGroup());
            JLabel jlCoord = new JLabel(String.valueOf(this.arrayEntities.get(i).getCoordX()) + ", " + this.arrayEntities.get(i).getCoordY());
            this.butGoto.add(new JButton("Goto"));
            this.butGoto.get(i).addActionListener(this);
            this.butDelete.add(new JButton("Delete"));
            this.butDelete.get(i).addActionListener(this);
            box.add(jlGroup);
            box.add(jlName);
            box.add(jlCoord);
            box.add(this.butGoto.get(i));
            box.add(this.butDelete.get(i));
            this.add(box);
            ++i;
        }
        if (this.arrayEntities.size() > 0) {
            GridMapMain.centerViewportCoordX = this.arrayEntities.get(0).getCoordX();
            GridMapMain.centerViewportCoordY = this.arrayEntities.get(0).getCoordY();
        }
        this.revalidate();
    }

    private void loadEntitiesFromFile() {
        File file = new File("GridMapEntities.dat");
        if (!file.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream("GridMapEntities.dat");
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                this.arrayEntities.add(new EntityObject());
                oos.writeObject(this.arrayEntities);
                oos.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        } else {
            try {
                FileInputStream fis = new FileInputStream("GridMapEntities.dat");
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.arrayEntities = (ArrayList)ois.readObject();
                ois.close();
            }
            catch (FileNotFoundException fnf) {
                this.statusMsg.setText("File Not Found");
            }
            catch (EOFException eof) {
                this.statusMsg.setText("No Entities");
            }
            catch (Exception ex) {
                System.out.println(ex);
                this.statusMsg.setText("Unknown Error");
            }
        }
    }

    private void saveEntitiesToFile() {
        try {
            FileOutputStream fos = new FileOutputStream("GridMapEntities.dat");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.arrayEntities);
            oos.close();
            this.statusMsg.setText("Save Success.");
        }
        catch (Exception ex) {
            this.statusMsg.setText("Save Error.");
        }
    }
}

