/*
 * Decompiled with CFR 0.152.
 */
package dev.ArkNLA.GridMap;

import dev.ArkNLA.GridMap.EntityObject;
import dev.ArkNLA.GridMap.GridMapMain;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PaneMap
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    ArrayList<Point> pt1 = new ArrayList();
    ArrayList<Point> pt2 = new ArrayList();
    ArrayList<Point> pt3 = new ArrayList();
    ArrayList<Point> pt4 = new ArrayList();
    ArrayList<Point> pt5 = new ArrayList();
    ArrayList<Point> pt6 = new ArrayList();
    ArrayList<Point> tt1 = new ArrayList();
    ArrayList<Point> ot1 = new ArrayList();
    int mouseStartX = 0;
    int mouseStartY = 0;
    int cursorPositionX = 0;
    int cursorPositionY = 0;
    int worldSize;
    int gridSize;
    int gridsPerWorld;
    Rectangle viewport = this.getVisibleRect();

    PaneMap() {
        this.worldSize = GridMapMain.worldSize;
        this.gridsPerWorld = GridMapMain.gridsPerWorld;
        this.gridSize = this.worldSize / this.gridsPerWorld;
        this.hardCodeEntities();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setVisible(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.worldSize, this.worldSize);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.worldSize = GridMapMain.worldSize;
        this.gridsPerWorld = GridMapMain.gridsPerWorld;
        this.gridSize = this.worldSize / this.gridsPerWorld;
        this.viewport = this.getVisibleRect();
        Graphics2D g2 = (Graphics2D)g;
        int i = 0;
        while (i < this.worldSize) {
            if (i % this.gridSize == 0) {
                g2.drawLine(0, i, this.worldSize, i);
                g2.drawLine(i, 0, i, this.worldSize);
            }
            ++i;
        }
        g2.fillOval(this.viewport.x + this.viewport.width / 2, this.viewport.y + this.viewport.height / 2, 7, 7);
        g2.drawOval(this.worldSize / 2 - 10, this.worldSize / 2 - 10, 20, 20);
        if (GridMapMain.paneEntities.arrayEntities.size() > 0) {
            for (EntityObject ent : GridMapMain.paneEntities.arrayEntities) {
                int ptx = ent.getCoordX();
                int pty = ent.getCoordY();
                int x = ptx * this.gridSize;
                int y = this.worldSize - pty * this.gridSize;
                if (ent.getGroup().toLowerCase().equals("titan")) {
                    g2.setColor(Color.orange);
                    g2.fillRect(x, y, this.gridSize, this.gridSize);
                    continue;
                }
                if (ent.getGroup().toLowerCase().equals("player")) {
                    g2.setColor(Color.black);
                    g2.fillRect(x, y, this.gridSize, this.gridSize);
                    continue;
                }
                g2.setColor(Color.BLUE);
                g2.fillOval(x, y, this.gridSize, this.gridSize);
            }
        }
        g2.setColor(Color.white);
        g2.fillRect(100, 100, 200, 50);
        g2.setColor(Color.black);
        g2.drawString("Right Click to save a position", 105, 120);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, (int)this.viewport.getX() + 100, (int)this.viewport.getY() + 35);
        g2.setColor(Color.black);
        g2.drawString(String.valueOf(String.valueOf("Cursor: " + String.valueOf(this.cursorPositionX))) + ", " + String.valueOf(this.cursorPositionY), (int)this.viewport.getX() + 5, (int)this.viewport.getY() + 10);
        g2.drawString("VP x,y: " + String.valueOf(this.viewport.x) + ", " + String.valueOf(this.viewport.y), (int)this.viewport.getX() + 5, (int)this.viewport.getY() + 20);
        g2.drawString("Dot: " + String.valueOf(this.viewport.x + this.viewport.width / 2) + ", " + String.valueOf(this.viewport.y + this.viewport.height / 2), (int)this.viewport.getX() + 5, (int)this.viewport.getY() + 30);
        String coordString = String.valueOf(String.valueOf((this.viewport.x + this.viewport.width / 2) / this.gridSize)) + ", " + String.valueOf(this.worldSize / this.gridSize - (this.viewport.y + this.viewport.height / 2) / this.gridSize);
        g2.setColor(Color.white);
        g2.fillRect((int)this.viewport.getX() + this.viewport.width / 2 - 60, (int)this.viewport.getY() + this.viewport.height - 25, 80, 20);
        g2.setColor(Color.black);
        g2.setFont(new Font("default", 1, 16));
        g2.drawString(coordString, (int)this.viewport.getX() + this.viewport.width / 2 - 50, (int)this.viewport.getY() + this.viewport.height - 10);
    }

    public void gotoCoord() {
        int x = GridMapMain.centerViewportCoordX * this.gridSize;
        int y = this.worldSize - GridMapMain.centerViewportCoordY * this.gridSize;
        this.scrollRectToVisible(new Rectangle(x - this.viewport.width / 2, y - this.viewport.height / 2, this.viewport.width, this.viewport.height));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point vpp = new Point(this.getVisibleRect().x, this.getVisibleRect().y);
        vpp.translate(this.mouseStartX - e.getX(), this.mouseStartY - e.getY());
        this.scrollRectToVisible(new Rectangle(vpp, this.getVisibleRect().getSize()));
        GridMapMain.centerViewportCoordX = (this.viewport.x + this.viewport.width / 2) / this.gridSize;
        GridMapMain.centerViewportCoordY = this.worldSize / this.gridSize - (this.viewport.y + this.viewport.height / 2) / this.gridSize;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.cursorPositionX = e.getX();
        this.cursorPositionY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            int x = 307 * this.gridSize;
            int y = this.worldSize - 395 * this.gridSize;
            GridMapMain.centerViewportCoordX = (this.viewport.x + this.viewport.width / 2) / this.gridSize;
            GridMapMain.centerViewportCoordY = this.worldSize / this.gridSize - (this.viewport.y + this.viewport.height / 2) / this.gridSize;
        }
        if (e.getButton() == 3) {
            int tempX = (this.viewport.x + this.viewport.width / 2) / this.gridSize;
            int tempY = this.worldSize / this.gridSize - (this.viewport.y + this.viewport.height / 2) / this.gridSize;
            JTextField field1 = new JTextField("Name");
            JTextField field2 = new JTextField(String.valueOf(tempX));
            JTextField field3 = new JTextField(String.valueOf(tempY));
            JTextField field4 = new JTextField("0");
            JPanel popup = new JPanel(new GridLayout(0, 1));
            popup.add(new JLabel("Name:"));
            popup.add(field1);
            popup.add(new JLabel("X:"));
            popup.add(field2);
            popup.add(new JLabel("Y:"));
            popup.add(field3);
            popup.add(new JLabel("Group:"));
            popup.add(field4);
            int result = JOptionPane.showConfirmDialog(null, popup, "Save Position", 2, -1);
            if (result == 0) {
                GridMapMain.paneEntities.addEntity(new EntityObject(field1.getText(), Integer.parseInt(field2.getText()), Integer.parseInt(field3.getText()), field4.getText()));
                GridMapMain.paneEntities.revalidate();
            } else {
                System.out.println("Cancelled");
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseStartX = e.getX();
        this.mouseStartY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void hardCodeEntities() {
        this.pt1.add(new Point(323, 380));
        this.pt1.add(new Point(325, 380));
        this.pt1.add(new Point(328, 385));
        this.pt1.add(new Point(328, 376));
        this.pt1.add(new Point(328, 374));
        this.pt2.add(new Point(306, 396));
        this.pt2.add(new Point(309, 402));
        this.pt2.add(new Point(305, 300));
        this.pt2.add(new Point(302, 392));
        this.pt2.add(new Point(314, 385));
        this.pt2.add(new Point(307, 385));
        this.pt3.add(new Point(321, 387));
        this.pt3.add(new Point(321, 388));
        this.pt3.add(new Point(324, 386));
        this.pt3.add(new Point(324, 392));
        this.pt3.add(new Point(328, 385));
        this.pt4.add(new Point(333, 419));
        this.pt4.add(new Point(331, 415));
        this.pt4.add(new Point(327, 424));
        this.pt4.add(new Point(329, 423));
        this.pt4.add(new Point(333, 425));
        this.pt4.add(new Point(335, 422));
        this.pt5.add(new Point(312, 383));
        this.pt5.add(new Point(307, 389));
        this.pt5.add(new Point(310, 378));
        this.pt5.add(new Point(317, 377));
        this.pt5.add(new Point(314, 383));
        this.pt6.add(new Point(335, 424));
        this.pt6.add(new Point(332, 429));
        this.pt6.add(new Point(329, 423));
        this.pt6.add(new Point(335, 426));
        this.pt6.add(new Point(338, 424));
        this.pt6.add(new Point(336, 422));
        this.tt1.add(new Point(282, 380));
        this.tt1.add(new Point(291, 390));
        this.tt1.add(new Point(292, 387));
        this.tt1.add(new Point(291, 385));
        this.tt1.add(new Point(275, 378));
        this.tt1.add(new Point(285, 382));
        this.tt1.add(new Point(280, 373));
        this.tt1.add(new Point(287, 372));
        this.tt1.add(new Point(277, 370));
        this.tt1.add(new Point(274, 383));
        this.tt1.add(new Point(288, 374));
        this.tt1.add(new Point(285, 377));
        this.tt1.add(new Point(284, 377));
        this.tt1.add(new Point(274, 372));
        this.tt1.add(new Point(281, 370));
        this.tt1.add(new Point(290, 376));
        this.tt1.add(new Point(289, 375));
        this.tt1.add(new Point(280, 377));
        this.tt1.add(new Point(281, 374));
        this.ot1.add(new Point(331, 410));
        this.ot1.add(new Point(329, 407));
        this.ot1.add(new Point(334, 413));
        this.ot1.add(new Point(335, 412));
        this.ot1.add(new Point(331, 413));
        this.ot1.add(new Point(332, 412));
        this.ot1.add(new Point(333, 411));
        this.ot1.add(new Point(330, 411));
        this.ot1.add(new Point(328, 410));
        this.ot1.add(new Point(333, 410));
        this.ot1.add(new Point(332, 409));
        this.ot1.add(new Point(330, 407));
        this.ot1.add(new Point(329, 408));
        this.ot1.add(new Point(332, 414));
        this.ot1.add(new Point(335, 409));
        this.ot1.add(new Point(335, 414));
        this.ot1.add(new Point(334, 412));
        this.ot1.add(new Point(333, 409));
        this.ot1.add(new Point(331, 411));
        this.ot1.add(new Point(329, 409));
        this.ot1.add(new Point(329, 412));
        this.ot1.add(new Point(327, 410));
        this.ot1.add(new Point(329, 406));
        this.ot1.add(new Point(331, 409));
        this.ot1.add(new Point(329, 413));
    }
}

