/*
 * Decompiled with CFR 0.152.
 */
package dev.ArkNLA.pixelTiles;

import dev.ArkNLA.pixelTiles.PanelTools;
import dev.ArkNLA.pixelTiles.PixelTilesMain;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class PanelDraw
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private Boolean mousePressed = false;
    private Boolean mouseClicked = false;
    private Point mouseLoc;
    private BufferedImage imageUserDrawn = null;
    boolean toolActive = false;
    boolean toolMirrorVS = false;
    boolean toolMirrorHS = false;
    boolean toolMirror4S = false;
    boolean toolDuplicateVS = false;
    boolean toolDuplicateHS = false;
    boolean toolDuplicate4S = false;
    Graphics2D g2;
    Graphics2D g2pane;
    private int pX;
    private int pY;
    private int line;
    private int step;
    private int gridSize;
    private int gridSizeCorrected = 0;
    private Boolean boolClearImage = false;
    int userGrid = 1;

    PanelDraw() {
        this.setLayout(new BorderLayout());
        this.mouseLoc = new Point(0, 0);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setOpaque(false);
        this.setVisible(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void paint(Graphics pane) {
        if (this.boolClearImage.booleanValue()) {
            this.imageUserDrawn = null;
            this.boolClearImage = false;
        }
        pane.setColor(Color.WHITE);
        pane.fillRect(0, 0, this.getWidth(), this.getHeight());
        pane.setColor(Color.LIGHT_GRAY);
        transpWidth = 0;
        transpHeight = 0;
        ** GOTO lbl16
        {
            pane.fillRect(transpWidth, transpHeight, 10, 10);
            transpWidth += 20;
            do {
                if (transpWidth < this.getWidth()) continue block2;
                transpWidth = transpHeight % 20 == 0 ? 10 : 0;
                transpHeight += 10;
lbl16:
                // 2 sources

            } while (transpHeight < this.getHeight());
        }
        this.panelSize();
        if (this.imageUserDrawn == null) {
            try {
                this.imageUserDrawn = ImageIO.read(new File("transparent-master.png"));
            }
            catch (IOException e) {
                this.imageUserDrawn = new BufferedImage(this.gridSizeCorrected, this.gridSizeCorrected, 2);
            }
            this.g2 = this.imageUserDrawn.createGraphics();
            this.g2.setColor(Color.white);
            this.g2.fillRect(0, 0, this.gridSizeCorrected, this.gridSizeCorrected);
        } else {
            this.imageUserDrawn = (BufferedImage)this.getScaledImage(this.imageUserDrawn, this.gridSizeCorrected, this.gridSizeCorrected);
            this.g2 = (Graphics2D)this.imageUserDrawn.getGraphics();
        }
        if (this.mousePressed.booleanValue() || this.mouseClicked.booleanValue()) {
            p = this.findGridContainingMouse();
            dx = p.x;
            dy = p.y;
            this.g2.setColor(PixelTilesMain.userColor);
            this.g2.fillRect(dx, dy, this.step, this.step);
            if (this.toolDuplicateVS) {
                this.mouseLoc.x = this.mouseLoc.x < this.gridSizeCorrected / 2 ? this.gridSizeCorrected / 2 + this.mouseLoc.x : (this.mouseLoc.x -= this.gridSizeCorrected / 2);
                p = this.findGridContainingMouse();
                this.g2.fillRect(p.x, dy, this.step, this.step);
            }
            if (this.toolDuplicateHS) {
                this.mouseLoc.y = this.mouseLoc.y < this.gridSizeCorrected / 2 ? this.gridSizeCorrected / 2 + this.mouseLoc.y : (this.mouseLoc.y -= this.gridSizeCorrected / 2);
                p = this.findGridContainingMouse();
                this.g2.fillRect(dx, p.y, this.step, this.step);
            }
            if (this.toolDuplicate4S) {
                this.mouseLoc.x = this.mouseLoc.x < this.gridSizeCorrected / 2 ? this.gridSizeCorrected / 2 + this.mouseLoc.x : (this.mouseLoc.x -= this.gridSizeCorrected / 2);
                p = this.findGridContainingMouse();
                this.g2.fillRect(p.x, dy, this.step, this.step);
                this.mouseLoc.y = this.mouseLoc.y < this.gridSizeCorrected / 2 ? this.gridSizeCorrected / 2 + this.mouseLoc.y : (this.mouseLoc.y -= this.gridSizeCorrected / 2);
                p = this.findGridContainingMouse();
                this.g2.fillRect(dx, p.y, this.step, this.step);
            }
            if (this.toolMirrorVS) {
                this.mouseLoc.x = this.gridSizeCorrected - this.mouseLoc.x;
                p = this.findGridContainingMouse();
                this.g2.fillRect(p.x, dy, this.step, this.step);
            }
            if (this.toolMirrorHS) {
                this.mouseLoc.y = this.gridSizeCorrected - this.mouseLoc.y;
                p = this.findGridContainingMouse();
                this.g2.fillRect(dx, p.y, this.step, this.step);
            }
            if (this.toolMirror4S) {
                this.mouseLoc.x = this.gridSizeCorrected - this.mouseLoc.x;
                this.mouseLoc.y = this.gridSizeCorrected - this.mouseLoc.y;
                p = this.findGridContainingMouse();
                this.g2.fillRect(p.x, dy, this.step, this.step);
                this.g2.fillRect(dx, p.y, this.step, this.step);
                this.mouseLoc.x = this.gridSizeCorrected - this.mouseLoc.x;
                this.mouseLoc.y = this.gridSizeCorrected - this.mouseLoc.y;
                this.g2.fillRect(p.x, p.y, this.step, this.step);
            }
            this.mouseClicked = false;
        }
        pane.drawImage(this.imageUserDrawn, 0, 0, this.gridSizeCorrected, this.gridSizeCorrected, this);
        PixelTilesMain.userImage = this.imageUserDrawn;
        this.line = this.step;
        i = 0;
        while (i < this.userGrid) {
            pane.drawLine(0, this.line, this.gridSizeCorrected, this.line);
            this.line += this.step;
            ++i;
        }
        this.line = this.step;
        i = 0;
        while (i < this.userGrid) {
            pane.drawLine(this.line, 0, this.line, this.gridSizeCorrected);
            this.line += this.step;
            ++i;
        }
        this.g2pane = (Graphics2D)pane;
        if (this.toolActive) {
            this.g2pane.setStroke(new BasicStroke(5.0f));
            if (this.toolDuplicateVS || this.toolMirrorVS) {
                this.g2pane.drawLine(this.gridSizeCorrected / 2, 0, this.gridSizeCorrected / 2, this.gridSizeCorrected);
            }
            if (this.toolDuplicateHS || this.toolMirrorHS) {
                this.g2pane.drawLine(0, this.gridSizeCorrected / 2, this.gridSizeCorrected, this.gridSizeCorrected / 2);
            }
            if (this.toolDuplicate4S || this.toolMirror4S) {
                this.g2pane.drawLine(0, this.gridSizeCorrected / 2, this.gridSizeCorrected, this.gridSizeCorrected / 2);
                this.g2pane.drawLine(this.gridSizeCorrected / 2, 0, this.gridSizeCorrected / 2, this.gridSizeCorrected);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mouseClicked = true;
            this.repaint();
            PanelTools.panePreview.repaint();
        }
        if (e.getButton() == 3) {
            int x = e.getX();
            int y = e.getY();
            int c = this.imageUserDrawn.getRGB(x, y);
            int a = c >> 24 & 0xFF;
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c & 0xFF;
            PixelTilesMain.userColor = new Color(r, g, b, a);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mousePressed = true;
            this.repaint();
            PanelTools.panePreview.repaint();
        }
        if (e.getButton() == 3) {
            int x = e.getX();
            int y = e.getY();
            int c = this.imageUserDrawn.getRGB(x, y);
            int a = c >> 24 & 0xFF;
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c & 0xFF;
            PixelTilesMain.paneColorSelect.setColor(r, g, b, a);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mousePressed = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mousePressed = true;
        int x = e.getX();
        int y = e.getY();
        if (x > this.gridSizeCorrected) {
            x = this.gridSizeCorrected;
        }
        if (y > this.gridSizeCorrected) {
            y = this.gridSizeCorrected;
        }
        this.mouseLoc.x = x;
        this.mouseLoc.y = y;
        this.repaint();
        PanelTools.panePreview.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x > this.gridSizeCorrected) {
            x = this.gridSizeCorrected;
        }
        if (y > this.gridSizeCorrected) {
            y = this.gridSizeCorrected;
        }
        this.mouseLoc.x = x;
        this.mouseLoc.y = y;
        this.repaint();
    }

    private void panelSize() {
        this.pX = this.getWidth();
        this.pY = this.getHeight();
        this.gridSize = this.pX > this.pY ? this.pY : this.pX;
        this.userGrid = PixelTilesMain.userGridSize;
        this.step = this.gridSize / this.userGrid;
        this.gridSizeCorrected = this.gridSize - this.gridSize % this.userGrid;
    }

    private Image getScaledImage(Image srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 1);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }

    public void clearImage() {
        this.boolClearImage = true;
    }

    private Point findGridContainingMouse() {
        int dx = 0;
        int dy = 0;
        int i = 0;
        while (i < this.gridSizeCorrected + this.step) {
            if (this.mouseLoc.x < i) {
                dx = i - this.step;
                break;
            }
            dx = this.gridSizeCorrected - this.step;
            i += this.step;
        }
        i = 0;
        while (i < this.gridSizeCorrected + this.step) {
            if (this.mouseLoc.y < i) {
                dy = i - this.step;
                break;
            }
            dy = this.gridSizeCorrected - this.step;
            i += this.step;
        }
        return new Point(dx, dy);
    }

    public void setDrawTools(String tool) {
        switch (tool) {
            case "mvs": {
                if (this.toolMirrorVS) {
                    this.toolMirrorVS = false;
                    this.toolActive = false;
                    break;
                }
                this.toolMirrorVS = true;
                this.toolActive = true;
                break;
            }
            case "mhs": {
                if (this.toolMirrorHS) {
                    this.toolMirrorHS = false;
                    this.toolActive = false;
                    break;
                }
                this.toolMirrorHS = true;
                this.toolActive = true;
                break;
            }
            case "m4s": {
                if (this.toolMirror4S) {
                    this.toolMirror4S = false;
                    this.toolActive = false;
                    break;
                }
                this.toolMirror4S = true;
                this.toolActive = true;
                break;
            }
            case "dvs": {
                if (this.toolDuplicateVS) {
                    this.toolDuplicateVS = false;
                    this.toolActive = false;
                    break;
                }
                this.toolDuplicateVS = true;
                this.toolActive = true;
                break;
            }
            case "dhs": {
                if (this.toolDuplicateHS) {
                    this.toolDuplicateHS = false;
                    this.toolActive = false;
                    break;
                }
                this.toolDuplicateHS = true;
                this.toolActive = true;
                break;
            }
            case "d4s": {
                if (this.toolDuplicate4S) {
                    this.toolDuplicate4S = false;
                    this.toolActive = false;
                    break;
                }
                this.toolDuplicate4S = true;
                this.toolActive = true;
            }
        }
    }

    public void disableAllDrawTools() {
        this.toolActive = false;
        this.toolMirrorVS = false;
        this.toolMirrorHS = false;
        this.toolMirror4S = false;
        this.toolDuplicateVS = false;
        this.toolDuplicateHS = false;
        this.toolDuplicate4S = false;
    }
}

