/*
 * Decompiled with CFR 0.152.
 */
package dev.ArkNLA.pixelTiles;

import dev.ArkNLA.pixelTiles.PanelTools;
import dev.ArkNLA.pixelTiles.PixelTilesMain;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PanelDrawTools
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JScrollPane scrollPane;
    JTextArea areaForTips = new JTextArea(5, 10);
    String toolInUse = "";
    JPanel paneOther = new JPanel();
    JButton butClearImage = new JButton("Clear");
    JPanel paneMirror = new JPanel();
    JButton butMirrorVS = new JButton(new ImageIcon("mvs-button.png"));
    JButton butMirrorHS = new JButton(new ImageIcon("mhs-button.png"));
    JButton butMirror4S = new JButton(new ImageIcon("m4s-button.png"));
    JPanel paneDuplicate = new JPanel();
    JButton butDuplicateVS = new JButton(new ImageIcon("dvs-button.png"));
    JButton butDuplicateHS = new JButton(new ImageIcon("dhs-button.png"));
    JButton butDuplicate4S = new JButton(new ImageIcon("d4s-button.png"));
    ArrayList<String> tips = new ArrayList();

    PanelDrawTools() {
        this.butClearImage.addActionListener(this);
        this.paneOther.add(this.butClearImage);
        this.butMirrorVS.addActionListener(this);
        this.butMirrorHS.addActionListener(this);
        this.butMirror4S.addActionListener(this);
        this.paneMirror.add(this.butMirrorVS);
        this.paneMirror.add(this.butMirrorHS);
        this.paneMirror.add(this.butMirror4S);
        this.butDuplicateVS.addActionListener(this);
        this.butDuplicateHS.addActionListener(this);
        this.butDuplicate4S.addActionListener(this);
        this.paneDuplicate.add(this.butDuplicateVS);
        this.paneDuplicate.add(this.butDuplicateHS);
        this.paneDuplicate.add(this.butDuplicate4S);
        this.tips.add("Right-Click on a color in the drawing area to select that color.");
        this.tips.add("Set custom paint grid to 1 to wash entire image in one color.");
        this.tips.add("Minecraft blocks are 16x16 pixels drawn/saved.");
        this.areaForTips.setMargin(new Insets(4, 4, 4, 4));
        this.areaForTips.setWrapStyleWord(true);
        this.areaForTips.setLineWrap(true);
        this.areaForTips.setEditable(false);
        this.areaForTips.setFont(new Font("Serif", 1, 16));
        this.areaForTips.setText("TIPS:\n-----\n");
        this.scrollPane = new JScrollPane(this.areaForTips);
        int i = 0;
        while (i < this.tips.size()) {
            String temp = this.areaForTips.getText();
            temp = String.valueOf(temp) + this.tips.get(i) + "\n\n";
            this.areaForTips.setText(temp);
            ++i;
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add(this.paneOther);
        this.add(this.paneMirror);
        this.add(this.paneDuplicate);
        this.add(this.scrollPane);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.butClearImage) {
            PixelTilesMain.paneDraw.clearImage();
            PixelTilesMain.paneDraw.repaint();
            PanelTools.panePreview.repaint();
        }
        if (source == this.butMirrorVS) {
            this.disableConflictingDrawTools("mvs");
            PixelTilesMain.paneDraw.setDrawTools("mvs");
            PixelTilesMain.paneDraw.repaint();
        }
        if (source == this.butMirrorHS) {
            this.disableConflictingDrawTools("mhs");
            PixelTilesMain.paneDraw.setDrawTools("mhs");
            PixelTilesMain.paneDraw.repaint();
        }
        if (source == this.butMirror4S) {
            this.disableConflictingDrawTools("m4s");
            PixelTilesMain.paneDraw.setDrawTools("m4s");
            PixelTilesMain.paneDraw.repaint();
        }
        if (source == this.butDuplicateVS) {
            this.disableConflictingDrawTools("dvs");
            PixelTilesMain.paneDraw.setDrawTools("dvs");
            PixelTilesMain.paneDraw.repaint();
        }
        if (source == this.butDuplicateHS) {
            this.disableConflictingDrawTools("dhs");
            PixelTilesMain.paneDraw.setDrawTools("dhs");
            PixelTilesMain.paneDraw.repaint();
        }
        if (source == this.butDuplicate4S) {
            this.disableConflictingDrawTools("d4s");
            PixelTilesMain.paneDraw.setDrawTools("d4s");
            PixelTilesMain.paneDraw.repaint();
        }
    }

    private void disableConflictingDrawTools(String toolUsed) {
        switch (toolUsed) {
            case "mvs": {
                if (this.toolInUse == "mvs") {
                    this.allToolButtonsEnabled();
                    break;
                }
                this.toolInUse = "mvs";
                this.butMirrorVS.setBackground(Color.GREEN);
                this.butMirrorHS.setEnabled(false);
                this.butMirror4S.setEnabled(false);
                this.butDuplicateVS.setEnabled(false);
                this.butDuplicateHS.setEnabled(false);
                this.butDuplicate4S.setEnabled(false);
                break;
            }
            case "mhs": {
                if (this.toolInUse == "mhs") {
                    this.allToolButtonsEnabled();
                    break;
                }
                this.toolInUse = "mhs";
                this.butMirrorVS.setEnabled(false);
                this.butMirrorHS.setBackground(Color.GREEN);
                this.butMirror4S.setEnabled(false);
                this.butDuplicateVS.setEnabled(false);
                this.butDuplicateHS.setEnabled(false);
                this.butDuplicate4S.setEnabled(false);
                break;
            }
            case "m4s": {
                if (this.toolInUse == "m4s") {
                    this.allToolButtonsEnabled();
                    break;
                }
                this.toolInUse = "m4s";
                this.butMirrorVS.setEnabled(false);
                this.butMirrorHS.setEnabled(false);
                this.butMirror4S.setBackground(Color.GREEN);
                this.butDuplicateVS.setEnabled(false);
                this.butDuplicateHS.setEnabled(false);
                this.butDuplicate4S.setEnabled(false);
                break;
            }
            case "dvs": {
                if (this.toolInUse == "dvs") {
                    this.allToolButtonsEnabled();
                    break;
                }
                this.toolInUse = "dvs";
                this.butMirrorVS.setEnabled(false);
                this.butMirrorHS.setEnabled(false);
                this.butMirror4S.setEnabled(false);
                this.butDuplicateVS.setBackground(Color.GREEN);
                this.butDuplicateHS.setEnabled(false);
                this.butDuplicate4S.setEnabled(false);
                break;
            }
            case "dhs": {
                if (this.toolInUse == "dhs") {
                    this.allToolButtonsEnabled();
                    break;
                }
                this.toolInUse = "dhs";
                this.butMirrorVS.setEnabled(false);
                this.butMirrorHS.setEnabled(false);
                this.butMirror4S.setEnabled(false);
                this.butDuplicateVS.setEnabled(false);
                this.butDuplicateHS.setBackground(Color.GREEN);
                this.butDuplicate4S.setEnabled(false);
                break;
            }
            case "d4s": {
                if (this.toolInUse == "d4s") {
                    this.allToolButtonsEnabled();
                    break;
                }
                this.toolInUse = "d4s";
                this.butMirrorVS.setEnabled(false);
                this.butMirrorHS.setEnabled(false);
                this.butMirror4S.setEnabled(false);
                this.butDuplicateVS.setEnabled(false);
                this.butDuplicateHS.setEnabled(false);
                this.butDuplicate4S.setBackground(Color.GREEN);
            }
        }
    }

    private void allToolButtonsEnabled() {
        this.butMirrorVS.setEnabled(true);
        this.butMirrorHS.setEnabled(true);
        this.butMirror4S.setEnabled(true);
        this.butDuplicateVS.setEnabled(true);
        this.butDuplicateHS.setEnabled(true);
        this.butDuplicate4S.setEnabled(true);
        this.butMirrorVS.setBackground(Color.LIGHT_GRAY);
        this.butMirrorHS.setBackground(Color.LIGHT_GRAY);
        this.butMirror4S.setBackground(Color.LIGHT_GRAY);
        this.butDuplicateVS.setBackground(Color.LIGHT_GRAY);
        this.butDuplicateHS.setBackground(Color.LIGHT_GRAY);
        this.butDuplicate4S.setBackground(Color.LIGHT_GRAY);
    }
}

