/*
 * Decompiled with CFR 0.152.
 */
package dev.ArkNLA.pixelTiles;

import dev.ArkNLA.pixelTiles.PixelTilesMain;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PanelSave
extends JPanel
implements ActionListener,
KeyListener {
    private JLabel statusMessage = new JLabel("Save Image:");
    private JButton buttonSaveAs = new JButton("Save As");
    private BufferedImage userImage;
    private int imageSize = 250;
    private JLabel labelImageSize;
    private JTextField textImageSize = new JTextField(3);
    private File workingDirectory;
    String stringSelectedFile = "";
    private JPanel paneSaveImage = new JPanel();

    PanelSave() {
        this.buttonSaveAs.addActionListener(this);
        this.labelImageSize = new JLabel("Image Size: ");
        this.labelImageSize.setHorizontalAlignment(2);
        this.textImageSize.addKeyListener(this);
        this.textImageSize.setHorizontalAlignment(4);
        this.textImageSize.setText(String.valueOf(this.imageSize));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.paneSaveImage.setSize(125, 100);
        this.paneSaveImage.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        this.paneSaveImage.add((Component)this.labelImageSize, c);
        c.gridy = 1;
        c.gridx = 0;
        this.paneSaveImage.add((Component)this.textImageSize, c);
        c.gridy = 2;
        c.gridx = 0;
        this.paneSaveImage.add((Component)this.buttonSaveAs, c);
        this.add((Component)this.statusMessage, "North");
        this.add((Component)this.paneSaveImage, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.buttonSaveAs) {
            this.showSaveAsDialog();
        }
    }

    private void showSaveAsDialog() {
        if (this.workingDirectory == null) {
            this.workingDirectory = new File("images/");
            if (!this.workingDirectory.exists()) {
                this.workingDirectory.mkdirs();
            }
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.workingDirectory);
        fileChooser.setFileSelectionMode(0);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("PNG Image", "png"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            this.workingDirectory = fileChooser.getCurrentDirectory();
            File selectedFile = fileChooser.getSelectedFile();
            this.stringSelectedFile = selectedFile.getAbsolutePath();
            this.saveImage();
        }
    }

    private void saveImage() {
        try {
            this.userImage = (BufferedImage)PixelTilesMain.userImage;
            this.userImage = (BufferedImage)this.getScaledImage(this.userImage, this.imageSize, this.imageSize);
            if (this.stringSelectedFile.length() > 0) {
                File img = new File(String.valueOf(this.stringSelectedFile) + ".png");
                if (img.exists()) {
                    int i = 1;
                    while (img.exists()) {
                        img = new File(String.valueOf(this.stringSelectedFile) + "(" + i + ").png");
                        ++i;
                    }
                    this.stringSelectedFile = String.valueOf(this.stringSelectedFile) + "(" + (i - 1) + ")";
                }
                try {
                    ImageIO.write((RenderedImage)this.userImage, "PNG", new File(String.valueOf(this.stringSelectedFile) + ".png"));
                    this.statusMessage.setText("Image has been saved.");
                    this.stringSelectedFile = "";
                }
                catch (Exception ex) {
                    this.statusMessage.setText("File not saved. File.");
                    ex.printStackTrace();
                }
            } else {
                this.statusMessage.setText("Please name your image.");
            }
        }
        catch (Exception e) {
            this.statusMessage.setText("File not saved. saveImage.");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object source = e.getSource();
        if (source == this.textImageSize) {
            try {
                this.imageSize = Integer.parseInt(this.textImageSize.getText());
                this.labelImageSize.setText("Image Size: " + this.imageSize + "x" + this.imageSize);
            }
            catch (Exception ex) {
                this.textImageSize.setText(String.valueOf(this.imageSize));
                this.labelImageSize.setText("Image Size: " + this.imageSize + "x" + this.imageSize);
            }
        }
        this.revalidate();
    }

    private Image getScaledImage(Image srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 1);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }
}

